/*
 * Copyright (c) 2021, 2023 Arm Limited.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */


#include "arm_gemm.hpp"
#include <cstddef>
#include <cstdint>

#if defined(__aarch64__)

namespace arm_conv {
namespace depthwise {

void a64_u8q_packed_to_nhwc_3x3_s2_with_multiplier_output2x4_dot_depthfirst_impl(
  const uint8_t *const *const inptrs,
  uint8_t *const *const outptrs,
  const void *params,
  unsigned int n_output_channels,
  const arm_gemm::Requantize32& qp
)
{
  __asm__ __volatile__(
    "ldr q11, [%x[params], #0x0]\n"
    "ldr q5, [%x[params], #0x10]\n"
    "movi v8.16b, #0x1\n"
    "ushr v8.4s, v8.4s, #0x8\n"
    "ldr q6, [%x[params], #0x20]\n"
    "ldr q7, [%x[params], #0x30]\n"
    "movi v24.4s, #0x0\n"
    "movi v25.4s, #0x0\n"
    "ldr x20, [%x[inptrs], #0x8]\n"
    "ld1 { v1.16b }, [x20]\n"
    "mov v28.16b, v1.16b\n"
    "mov v23.16b, v1.16b\n"
    "ldr x20, [%x[inptrs], #0x10]\n"
    "ld1 { v2.16b }, [x20]\n"
    "mov v30.16b, v1.16b\n"
    "mov v21.16b, v2.16b\n"
    "ldr x20, [%x[inptrs], #0x20]\n"
    "ld1 { v4.16b }, [x20]\n"
    "mov v20.16b, v2.16b\n"
    "mov v29.16b, v2.16b\n"
    "ldr x20, [%x[inptrs], #0x0]\n"
    "ld1 { v0.16b }, [x20]\n"
    "mov v9.16b, v4.16b\n"
    "mov v22.16b, v4.16b\n"
    "ldr x20, [%x[inptrs], #0x18]\n"
    "ld1 { v3.16b }, [x20]\n"
    "mov v31.16b, v4.16b\n"
    "ext v28.16b, v28.16b, v28.16b, #0x2\n"
    "ext v23.16b, v23.16b, v23.16b, #0x4\n"
    "ext v30.16b, v30.16b, v30.16b, #0x6\n"
    "add x20, %x[qp], %[offsetof_Requantize32_b_offset]\n"
    "ld1r { v12.4s }, [x20]\n"
    "ext v21.16b, v21.16b, v21.16b, #0x2\n"
    "ext v20.16b, v20.16b, v20.16b, #0x4\n"
    "add x20, %x[qp], %[offsetof_Requantize32_c_offset]\n"
    "ld1r { v14.4s }, [x20]\n"
    "ext v29.16b, v29.16b, v29.16b, #0x6\n"
    "ext v9.16b, v9.16b, v9.16b, #0x2\n"
    "add x20, %x[qp], %[offsetof_Requantize32_minval]\n"
    "ld1r { v13.4s }, [x20]\n"
    "ext v22.16b, v22.16b, v22.16b, #0x4\n"
    "ext v31.16b, v31.16b, v31.16b, #0x6\n"
    "add x20, %x[qp], %[offsetof_Requantize32_maxval]\n"
    "ld1r { v15.4s }, [x20]\n"
    "mov v27.16b, v0.16b\n"
    "mov v19.16b, v0.16b\n"
    "cmp %x[n_channels], #0x4\n"
    "mov x9, #0x0\n"
    "mov v18.16b, v0.16b\n"
    "mov v26.16b, v3.16b\n"
    "mov x28, #0x0\n"
    "ldp x27, x26, [%x[outptrs], #0x0]\n"
    "mov v17.16b, v3.16b\n"
    "mov v16.16b, v3.16b\n"
    "ldp x25, x24, [%x[outptrs], #0x10]\n"
    "ldp x23, x22, [%x[outptrs], #0x20]\n"
    "ext v27.16b, v27.16b, v27.16b, #0x2\n"
    "ext v19.16b, v19.16b, v19.16b, #0x4\n"
    "ldp x21, x20, [%x[outptrs], #0x30]\n"
    "add %x[params], %x[params], #0x40\n"
    "ext v18.16b, v18.16b, v18.16b, #0x6\n"
    "zip1 v1.4s, v1.4s, v23.4s\n"
    "zip1 v28.4s, v28.4s, v30.4s\n"
    "zip1 v2.4s, v2.4s, v20.4s\n"
    "zip1 v21.4s, v21.4s, v29.4s\n"
    "ext v26.16b, v26.16b, v26.16b, #0x2\n"
    "ext v17.16b, v17.16b, v17.16b, #0x4\n"
    "ext v16.16b, v16.16b, v16.16b, #0x6\n"
    "zip1 v4.4s, v4.4s, v22.4s\n"
    "zip1 v9.4s, v9.4s, v31.4s\n"
    "zip1 v0.4s, v0.4s, v19.4s\n"
    "zip1 v27.4s, v27.4s, v18.4s\n"
    "zip1 v1.4s, v1.4s, v28.4s\n"
    "zip1 v2.4s, v2.4s, v21.4s\n"
    ".inst 0x6f81e118  // udot v24.4s, v8.16b, v1.4b[0]\n"
    "zip1 v3.4s, v3.4s, v17.4s\n"
    "zip1 v26.4s, v26.4s, v16.4s\n"
    ".inst 0x6fa1e119  // udot v25.4s, v8.16b, v1.4b[1]\n"
    "zip1 v4.4s, v4.4s, v9.4s\n"
    "movi v23.4s, #0x0\n"
    ".inst 0x6f81e917  // udot v23.4s, v8.16b, v1.4b[2]\n"
    "movi v22.4s, #0x0\n"
    "movi v21.4s, #0x0\n"
    ".inst 0x6fa1e916  // udot v22.4s, v8.16b, v1.4b[3]\n"
    "movi v19.4s, #0x0\n"
    "movi v9.4s, #0x0\n"
    ".inst 0x6f82e115  // udot v21.4s, v8.16b, v2.4b[0]\n"
    "movi v10.4s, #0x0\n"
    "movi v20.4s, #0x0\n"
    ".inst 0x6fa2e113  // udot v19.4s, v8.16b, v2.4b[1]\n"
    "movi v18.4s, #0x0\n"
    "movi v17.4s, #0x0\n"
    ".inst 0x6f82e909  // udot v9.4s, v8.16b, v2.4b[2]\n"
    "movi v16.4s, #0x0\n"
    "zip1 v0.4s, v0.4s, v27.4s\n"
    ".inst 0x6fa2e90a  // udot v10.4s, v8.16b, v2.4b[3]\n"
    "zip1 v3.4s, v3.4s, v26.4s\n"
    ".inst 0x6f84e114  // udot v20.4s, v8.16b, v4.4b[0]\n"
    ".inst 0x6fa4e112  // udot v18.4s, v8.16b, v4.4b[1]\n"
    ".inst 0x6f84e911  // udot v17.4s, v8.16b, v4.4b[2]\n"
    ".inst 0x6fa4e910  // udot v16.4s, v8.16b, v4.4b[3]\n"
    "movi v31.4s, #0x0\n"
    "movi v30.4s, #0x0\n"
    "movi v26.4s, #0x0\n"
    ".inst 0x6f80e11f  // udot v31.4s, v8.16b, v0.4b[0]\n"
    "movi v27.4s, #0x0\n"
    "movi v28.4s, #0x0\n"
    ".inst 0x6fa0e11e  // udot v30.4s, v8.16b, v0.4b[1]\n"
    "movi v29.4s, #0x0\n"
    ".inst 0x6f80e91a  // udot v26.4s, v8.16b, v0.4b[2]\n"
    ".inst 0x6fa0e91b  // udot v27.4s, v8.16b, v0.4b[3]\n"
    ".inst 0x6f83e11c  // udot v28.4s, v8.16b, v3.4b[0]\n"
    ".inst 0x6fa3e11d  // udot v29.4s, v8.16b, v3.4b[1]\n"
    "add v24.4s, v24.4s, v21.4s\n"
    "add v25.4s, v25.4s, v19.4s\n"
    "add v23.4s, v23.4s, v9.4s\n"
    "add v22.4s, v22.4s, v10.4s\n"
    "add v21.4s, v20.4s, v21.4s\n"
    "movi v20.4s, #0x0\n"
    ".inst 0x6f83e914  // udot v20.4s, v8.16b, v3.4b[2]\n"
    "add v19.4s, v18.4s, v19.4s\n"
    "movi v18.4s, #0x0\n"
    ".inst 0x6fa3e912  // udot v18.4s, v8.16b, v3.4b[3]\n"
    "add v17.4s, v17.4s, v9.4s\n"
    "add v16.4s, v16.4s, v10.4s\n"
    "add v24.4s, v24.4s, v31.4s\n"
    "add v25.4s, v25.4s, v30.4s\n"
    "add v26.4s, v23.4s, v26.4s\n"
    "add v27.4s, v22.4s, v27.4s\n"
    "add v28.4s, v21.4s, v28.4s\n"
    "add v29.4s, v19.4s, v29.4s\n"
    "add v30.4s, v17.4s, v20.4s\n"
    "add v31.4s, v16.4s, v18.4s\n"
    "neg v12.4s, v12.4s\n"
    "mul v24.4s, v24.4s, v12.4s\n"
    "mul v25.4s, v25.4s, v12.4s\n"
    "mul v26.4s, v26.4s, v12.4s\n"
    "mul v27.4s, v27.4s, v12.4s\n"
    "mul v28.4s, v28.4s, v12.4s\n"
    "mul v29.4s, v29.4s, v12.4s\n"
    "mul v30.4s, v30.4s, v12.4s\n"
    "mul v31.4s, v31.4s, v12.4s\n"
    "zip1 v19.4s, v24.4s, v26.4s\n"
    "zip1 v18.4s, v25.4s, v27.4s\n"
    "zip1 v17.4s, v28.4s, v30.4s\n"
    "zip1 v16.4s, v29.4s, v31.4s\n"
    "zip1 v22.4s, v19.4s, v18.4s\n"
    "zip1 v23.4s, v17.4s, v16.4s\n"
    "add v24.4s, v24.4s, v11.4s\n"
    "add v25.4s, v25.4s, v11.4s\n"
    "add v26.4s, v26.4s, v11.4s\n"
    "add v27.4s, v27.4s, v11.4s\n"
    "add v28.4s, v28.4s, v11.4s\n"
    "add v29.4s, v29.4s, v11.4s\n"
    "add v30.4s, v30.4s, v11.4s\n"
    "add v31.4s, v31.4s, v11.4s\n"
    "ble 2f\n"
    "1:"  // Loop
    "ldr q8, [%x[params], #0x0]\n"
    "ldr q21, [%x[params], #0x10]\n"
    ".inst 0x6f80e0b8  // udot v24.4s, v5.16b, v0.4b[0]\n"
    ".inst 0x6fa0e0b9  // udot v25.4s, v5.16b, v0.4b[1]\n"
    "ldr q20, [%x[params], #0x20]\n"
    ".inst 0x6f80e8ba  // udot v26.4s, v5.16b, v0.4b[2]\n"
    ".inst 0x6fa0e8bb  // udot v27.4s, v5.16b, v0.4b[3]\n"
    "sub %x[n_channels], %x[n_channels], #0x4\n"
    ".inst 0x6f81e0d8  // udot v24.4s, v6.16b, v1.4b[0]\n"
    ".inst 0x6fa1e0d9  // udot v25.4s, v6.16b, v1.4b[1]\n"
    "cmp %x[n_channels], #0x4\n"
    "add x9, x9, #0x10\n"
    ".inst 0x6f81e8da  // udot v26.4s, v6.16b, v1.4b[2]\n"
    ".inst 0x6fa1e8db  // udot v27.4s, v6.16b, v1.4b[3]\n"
    ".inst 0x6f82e0bc  // udot v28.4s, v5.16b, v2.4b[0]\n"
    ".inst 0x6fa2e0bd  // udot v29.4s, v5.16b, v2.4b[1]\n"
    ".inst 0x6f82e8be  // udot v30.4s, v5.16b, v2.4b[2]\n"
    ".inst 0x6fa2e8bf  // udot v31.4s, v5.16b, v2.4b[3]\n"
    "ldr q5, [%x[params], #0x30]\n"
    ".inst 0x6f82e0f8  // udot v24.4s, v7.16b, v2.4b[0]\n"
    ".inst 0x6fa2e0f9  // udot v25.4s, v7.16b, v2.4b[1]\n"
    "sqrdmulh v24.4s, v24.4s, v8.4s\n"
    ".inst 0x6f82e8fa  // udot v26.4s, v7.16b, v2.4b[2]\n"
    ".inst 0x6fa2e8fb  // udot v27.4s, v7.16b, v2.4b[3]\n"
    "sqrdmulh v25.4s, v25.4s, v8.4s\n"
    ".inst 0x6f83e0dc  // udot v28.4s, v6.16b, v3.4b[0]\n"
    ".inst 0x6fa3e0dd  // udot v29.4s, v6.16b, v3.4b[1]\n"
    "sqrdmulh v26.4s, v26.4s, v8.4s\n"
    ".inst 0x6f83e8de  // udot v30.4s, v6.16b, v3.4b[2]\n"
    ".inst 0x6fa3e8df  // udot v31.4s, v6.16b, v3.4b[3]\n"
    "ldr q6, [%x[params], #0x40]\n"
    "sqrdmulh v27.4s, v27.4s, v8.4s\n"
    ".inst 0x6f84e0fc  // udot v28.4s, v7.16b, v4.4b[0]\n"
    ".inst 0x6fa4e0fd  // udot v29.4s, v7.16b, v4.4b[1]\n"
    "and v19.16b, v24.16b, v21.16b\n"
    ".inst 0x6f84e8fe  // udot v30.4s, v7.16b, v4.4b[2]\n"
    ".inst 0x6fa4e8ff  // udot v31.4s, v7.16b, v4.4b[3]\n"
    "ldr q7, [%x[params], #0x50]\n"
    "and v18.16b, v25.16b, v21.16b\n"
    "and v17.16b, v26.16b, v21.16b\n"
    "and v16.16b, v27.16b, v21.16b\n"
    "add %x[params], %x[params], #0x60\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v28.4s, v28.4s, v8.4s\n"
    "sqrdmulh v29.4s, v29.4s, v8.4s\n"
    "sqrdmulh v30.4s, v30.4s, v8.4s\n"
    "sqrdmulh v31.4s, v31.4s, v8.4s\n"
    "sqadd v24.4s, v24.4s, v19.4s\n"
    "sqadd v25.4s, v25.4s, v18.4s\n"
    "sqadd v26.4s, v26.4s, v17.4s\n"
    "sqadd v27.4s, v27.4s, v16.4s\n"
    "and v19.16b, v28.16b, v21.16b\n"
    "and v18.16b, v29.16b, v21.16b\n"
    "and v17.16b, v30.16b, v21.16b\n"
    "and v16.16b, v31.16b, v21.16b\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v28.4s, v28.4s, v19.4s\n"
    "sqadd v29.4s, v29.4s, v18.4s\n"
    "sqadd v30.4s, v30.4s, v17.4s\n"
    "sqadd v31.4s, v31.4s, v16.4s\n"
    "srshl v24.4s, v24.4s, v21.4s\n"
    "srshl v25.4s, v25.4s, v21.4s\n"
    "srshl v26.4s, v26.4s, v21.4s\n"
    "srshl v27.4s, v27.4s, v21.4s\n"
    "srshl v28.4s, v28.4s, v21.4s\n"
    "srshl v29.4s, v29.4s, v21.4s\n"
    "srshl v30.4s, v30.4s, v21.4s\n"
    "srshl v31.4s, v31.4s, v21.4s\n"
    "add v24.4s, v24.4s, v14.4s\n"
    "add v25.4s, v25.4s, v14.4s\n"
    "add v26.4s, v26.4s, v14.4s\n"
    "add v27.4s, v27.4s, v14.4s\n"
    "add v28.4s, v28.4s, v14.4s\n"
    "add v29.4s, v29.4s, v14.4s\n"
    "add v30.4s, v30.4s, v14.4s\n"
    "add v31.4s, v31.4s, v14.4s\n"
    "smin v24.4s, v24.4s, v15.4s\n"
    "smin v25.4s, v25.4s, v15.4s\n"
    "smin v26.4s, v26.4s, v15.4s\n"
    "smin v27.4s, v27.4s, v15.4s\n"
    "smin v28.4s, v28.4s, v15.4s\n"
    "smin v29.4s, v29.4s, v15.4s\n"
    "smin v30.4s, v30.4s, v15.4s\n"
    "smin v31.4s, v31.4s, v15.4s\n"
    "smax v24.4s, v24.4s, v13.4s\n"
    "smax v25.4s, v25.4s, v13.4s\n"
    "smax v26.4s, v26.4s, v13.4s\n"
    "smax v27.4s, v27.4s, v13.4s\n"
    "smax v28.4s, v28.4s, v13.4s\n"
    "smax v29.4s, v29.4s, v13.4s\n"
    "smax v30.4s, v30.4s, v13.4s\n"
    "smax v31.4s, v31.4s, v13.4s\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "uzp1 v25.16b, v25.16b, v25.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v27.16b, v27.16b, v27.16b\n"
    "uzp1 v28.16b, v28.16b, v28.16b\n"
    "uzp1 v29.16b, v29.16b, v29.16b\n"
    "uzp1 v30.16b, v30.16b, v30.16b\n"
    "uzp1 v31.16b, v31.16b, v31.16b\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "uzp1 v25.16b, v25.16b, v25.16b\n"
    "str s24, [x27, x28]\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v27.16b, v27.16b, v27.16b\n"
    "str s25, [x26, x28]\n"
    "uzp1 v28.16b, v28.16b, v28.16b\n"
    "uzp1 v29.16b, v29.16b, v29.16b\n"
    "str s26, [x25, x28]\n"
    "uzp1 v30.16b, v30.16b, v30.16b\n"
    "uzp1 v31.16b, v31.16b, v31.16b\n"
    "str s27, [x24, x28]\n"
    "str s28, [x23, x28]\n"
    "dup v24.4s, v22.s[0]\n"
    "dup v25.4s, v22.s[1]\n"
    "str s29, [x22, x28]\n"
    "dup v26.4s, v22.s[2]\n"
    "dup v27.4s, v22.s[3]\n"
    "str s30, [x21, x28]\n"
    "dup v28.4s, v23.s[0]\n"
    "dup v29.4s, v23.s[1]\n"
    "str s31, [x20, x28]\n"
    "dup v30.4s, v23.s[2]\n"
    "dup v31.4s, v23.s[3]\n"
    "add x28, x28, #0x4\n"
    "add v24.4s, v24.4s, v20.4s\n"
    "add v25.4s, v25.4s, v20.4s\n"
    "add v26.4s, v26.4s, v20.4s\n"
    "add v27.4s, v27.4s, v20.4s\n"
    "add v28.4s, v28.4s, v20.4s\n"
    "add v29.4s, v29.4s, v20.4s\n"
    "add v30.4s, v30.4s, v20.4s\n"
    "add v31.4s, v31.4s, v20.4s\n"
    "bgt 1b\n"
    "2:"  // Tail
    "ldr q21, [%x[params], #0x0]\n"
    "ldr q20, [%x[params], #0x10]\n"
    ".inst 0x6f80e0b8  // udot v24.4s, v5.16b, v0.4b[0]\n"
    ".inst 0x6fa0e0b9  // udot v25.4s, v5.16b, v0.4b[1]\n"
    ".inst 0x6f80e8ba  // udot v26.4s, v5.16b, v0.4b[2]\n"
    ".inst 0x6fa0e8bb  // udot v27.4s, v5.16b, v0.4b[3]\n"
    "cmp %x[n_channels], #0x4\n"
    "add x27, x27, x28\n"
    ".inst 0x6f81e0d8  // udot v24.4s, v6.16b, v1.4b[0]\n"
    ".inst 0x6fa1e0d9  // udot v25.4s, v6.16b, v1.4b[1]\n"
    "add x26, x26, x28\n"
    "add x25, x25, x28\n"
    ".inst 0x6f81e8da  // udot v26.4s, v6.16b, v1.4b[2]\n"
    ".inst 0x6fa1e8db  // udot v27.4s, v6.16b, v1.4b[3]\n"
    "add x24, x24, x28\n"
    "add x23, x23, x28\n"
    ".inst 0x6f82e0bc  // udot v28.4s, v5.16b, v2.4b[0]\n"
    ".inst 0x6fa2e0bd  // udot v29.4s, v5.16b, v2.4b[1]\n"
    "add x22, x22, x28\n"
    "add x21, x21, x28\n"
    ".inst 0x6f82e8be  // udot v30.4s, v5.16b, v2.4b[2]\n"
    ".inst 0x6fa2e8bf  // udot v31.4s, v5.16b, v2.4b[3]\n"
    "add x20, x20, x28\n"
    "add %x[params], %x[params], #0x20\n"
    ".inst 0x6f82e0f8  // udot v24.4s, v7.16b, v2.4b[0]\n"
    ".inst 0x6fa2e0f9  // udot v25.4s, v7.16b, v2.4b[1]\n"
    "sqrdmulh v24.4s, v24.4s, v21.4s\n"
    ".inst 0x6f82e8fa  // udot v26.4s, v7.16b, v2.4b[2]\n"
    ".inst 0x6fa2e8fb  // udot v27.4s, v7.16b, v2.4b[3]\n"
    "sqrdmulh v25.4s, v25.4s, v21.4s\n"
    ".inst 0x6f83e0dc  // udot v28.4s, v6.16b, v3.4b[0]\n"
    ".inst 0x6fa3e0dd  // udot v29.4s, v6.16b, v3.4b[1]\n"
    "sqrdmulh v26.4s, v26.4s, v21.4s\n"
    ".inst 0x6f83e8de  // udot v30.4s, v6.16b, v3.4b[2]\n"
    ".inst 0x6fa3e8df  // udot v31.4s, v6.16b, v3.4b[3]\n"
    "sqrdmulh v27.4s, v27.4s, v21.4s\n"
    ".inst 0x6f84e0fc  // udot v28.4s, v7.16b, v4.4b[0]\n"
    ".inst 0x6fa4e0fd  // udot v29.4s, v7.16b, v4.4b[1]\n"
    "and v19.16b, v24.16b, v20.16b\n"
    ".inst 0x6f84e8fe  // udot v30.4s, v7.16b, v4.4b[2]\n"
    ".inst 0x6fa4e8ff  // udot v31.4s, v7.16b, v4.4b[3]\n"
    "and v18.16b, v25.16b, v20.16b\n"
    "and v17.16b, v26.16b, v20.16b\n"
    "and v16.16b, v27.16b, v20.16b\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqrdmulh v28.4s, v28.4s, v21.4s\n"
    "sqrdmulh v29.4s, v29.4s, v21.4s\n"
    "sqrdmulh v30.4s, v30.4s, v21.4s\n"
    "sqrdmulh v31.4s, v31.4s, v21.4s\n"
    "sqadd v24.4s, v24.4s, v19.4s\n"
    "sqadd v25.4s, v25.4s, v18.4s\n"
    "sqadd v26.4s, v26.4s, v17.4s\n"
    "sqadd v27.4s, v27.4s, v16.4s\n"
    "and v19.16b, v28.16b, v20.16b\n"
    "and v18.16b, v29.16b, v20.16b\n"
    "and v17.16b, v30.16b, v20.16b\n"
    "and v16.16b, v31.16b, v20.16b\n"
    "sshr v19.4s, v19.4s, #0x1f\n"
    "sshr v18.4s, v18.4s, #0x1f\n"
    "sshr v17.4s, v17.4s, #0x1f\n"
    "sshr v16.4s, v16.4s, #0x1f\n"
    "sqadd v28.4s, v28.4s, v19.4s\n"
    "sqadd v29.4s, v29.4s, v18.4s\n"
    "sqadd v30.4s, v30.4s, v17.4s\n"
    "sqadd v31.4s, v31.4s, v16.4s\n"
    "srshl v24.4s, v24.4s, v20.4s\n"
    "srshl v25.4s, v25.4s, v20.4s\n"
    "srshl v26.4s, v26.4s, v20.4s\n"
    "srshl v27.4s, v27.4s, v20.4s\n"
    "srshl v28.4s, v28.4s, v20.4s\n"
    "srshl v29.4s, v29.4s, v20.4s\n"
    "srshl v30.4s, v30.4s, v20.4s\n"
    "srshl v31.4s, v31.4s, v20.4s\n"
    "add v24.4s, v24.4s, v14.4s\n"
    "add v25.4s, v25.4s, v14.4s\n"
    "add v26.4s, v26.4s, v14.4s\n"
    "add v27.4s, v27.4s, v14.4s\n"
    "add v28.4s, v28.4s, v14.4s\n"
    "add v29.4s, v29.4s, v14.4s\n"
    "add v30.4s, v30.4s, v14.4s\n"
    "add v31.4s, v31.4s, v14.4s\n"
    "smin v24.4s, v24.4s, v15.4s\n"
    "smin v25.4s, v25.4s, v15.4s\n"
    "smin v26.4s, v26.4s, v15.4s\n"
    "smin v27.4s, v27.4s, v15.4s\n"
    "smin v28.4s, v28.4s, v15.4s\n"
    "smin v29.4s, v29.4s, v15.4s\n"
    "smin v30.4s, v30.4s, v15.4s\n"
    "smin v31.4s, v31.4s, v15.4s\n"
    "smax v24.4s, v24.4s, v13.4s\n"
    "smax v25.4s, v25.4s, v13.4s\n"
    "smax v26.4s, v26.4s, v13.4s\n"
    "smax v27.4s, v27.4s, v13.4s\n"
    "smax v28.4s, v28.4s, v13.4s\n"
    "smax v29.4s, v29.4s, v13.4s\n"
    "smax v30.4s, v30.4s, v13.4s\n"
    "smax v31.4s, v31.4s, v13.4s\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "uzp1 v25.16b, v25.16b, v25.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v27.16b, v27.16b, v27.16b\n"
    "uzp1 v28.16b, v28.16b, v28.16b\n"
    "uzp1 v29.16b, v29.16b, v29.16b\n"
    "uzp1 v30.16b, v30.16b, v30.16b\n"
    "uzp1 v31.16b, v31.16b, v31.16b\n"
    "uzp1 v24.16b, v24.16b, v24.16b\n"
    "uzp1 v25.16b, v25.16b, v25.16b\n"
    "uzp1 v26.16b, v26.16b, v26.16b\n"
    "uzp1 v27.16b, v27.16b, v27.16b\n"
    "uzp1 v28.16b, v28.16b, v28.16b\n"
    "uzp1 v29.16b, v29.16b, v29.16b\n"
    "uzp1 v30.16b, v30.16b, v30.16b\n"
    "uzp1 v31.16b, v31.16b, v31.16b\n"
    "blt 3f\n"
    "str s24, [x27, #0x0]\n"
    "str s25, [x26, #0x0]\n"
    "str s26, [x25, #0x0]\n"
    "str s27, [x24, #0x0]\n"
    "str s28, [x23, #0x0]\n"
    "str s29, [x22, #0x0]\n"
    "str s30, [x21, #0x0]\n"
    "str s31, [x20, #0x0]\n"
    "b 4f\n"
    "3:"  // Tail: Oddments
    "subs %x[n_channels], %x[n_channels], #0x1\n"
    "st1 { v24.b }[0], [x27], #0x1\n"
    "st1 { v25.b }[0], [x26], #0x1\n"
    "st1 { v26.b }[0], [x25], #0x1\n"
    "st1 { v27.b }[0], [x24], #0x1\n"
    "st1 { v28.b }[0], [x23], #0x1\n"
    "st1 { v29.b }[0], [x22], #0x1\n"
    "st1 { v30.b }[0], [x21], #0x1\n"
    "st1 { v31.b }[0], [x20], #0x1\n"
    "beq 4f\n"
    "subs %x[n_channels], %x[n_channels], #0x1\n"
    "st1 { v24.b }[1], [x27], #0x1\n"
    "st1 { v25.b }[1], [x26], #0x1\n"
    "st1 { v26.b }[1], [x25], #0x1\n"
    "st1 { v27.b }[1], [x24], #0x1\n"
    "st1 { v28.b }[1], [x23], #0x1\n"
    "st1 { v29.b }[1], [x22], #0x1\n"
    "st1 { v30.b }[1], [x21], #0x1\n"
    "st1 { v31.b }[1], [x20], #0x1\n"
    "beq 4f\n"
    "subs %x[n_channels], %x[n_channels], #0x1\n"
    "st1 { v24.b }[2], [x27], #0x1\n"
    "st1 { v25.b }[2], [x26], #0x1\n"
    "st1 { v26.b }[2], [x25], #0x1\n"
    "st1 { v27.b }[2], [x24], #0x1\n"
    "st1 { v28.b }[2], [x23], #0x1\n"
    "st1 { v29.b }[2], [x22], #0x1\n"
    "st1 { v30.b }[2], [x21], #0x1\n"
    "st1 { v31.b }[2], [x20], #0x1\n"
    "beq 4f\n"
    "st1 { v24.b }[3], [x27], #0x1\n"
    "subs %x[n_channels], %x[n_channels], #0x1\n"
    "st1 { v25.b }[3], [x26], #0x1\n"
    "st1 { v26.b }[3], [x25], #0x1\n"
    "st1 { v27.b }[3], [x24], #0x1\n"
    "st1 { v28.b }[3], [x23], #0x1\n"
    "st1 { v29.b }[3], [x22], #0x1\n"
    "st1 { v30.b }[3], [x21], #0x1\n"
    "st1 { v31.b }[3], [x20], #0x1\n"
    "4:"  // Tail: End
    : [n_channels] "+&r" (n_output_channels), [params] "+&r" (params)
    : [inptrs] "r" (inptrs), [offsetof_Requantize32_b_offset] "I" (offsetof(arm_gemm::Requantize32, b_offset)), [offsetof_Requantize32_c_offset] "I" (offsetof(arm_gemm::Requantize32, c_offset)), [offsetof_Requantize32_maxval] "I" (offsetof(arm_gemm::Requantize32, maxval)), [offsetof_Requantize32_minval] "I" (offsetof(arm_gemm::Requantize32, minval)), [outptrs] "r" (outptrs), [qp] "r" (&qp)
    : "cc", "memory", "v0", "v1", "v2", "v3", "v4", "v5", "v6", "v7", "v8", "v9", "v10", "v11", "v12", "v13", "v14", "v15", "v16", "v17", "v18", "v19", "v20", "v21", "v22", "v23", "v24", "v25", "v26", "v27", "v28", "v29", "v30", "v31", "x9", "x20", "x21", "x22", "x23", "x24", "x25", "x26", "x27", "x28"
  );
}

}  // namespace depthwise
}  // namespace arm_conv

#endif  // defined(__aarch64__)
