'''OpenGL extension QCOM.texture_lod_bias

This module customises the behaviour of the 
OpenGL.raw.GLES2.QCOM.texture_lod_bias to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension reintroduces the texture LOD bias operation from
	EXT_texture_lod_bias which is written based on OpenGL ES 1.1.
	It provides a mean to bias the lambda computation by a
	constant (signed) value. This bias can provide a way to blur or
	pseudo-sharpen OpenGL ES's standard texture filtering.
	
	This blurring or pseudo-sharpening may be useful for special
	effects (such as depth-of-field effects) or image processing
	techniques (where the mipmap levels act as pre-downsampled image
	versions). On some implementations, increasing the texture LOD
	bias may improve texture filtering performance (at the cost of
	texture blurriness).

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/QCOM/texture_lod_bias.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.QCOM.texture_lod_bias import *
from OpenGL.raw.GLES2.QCOM.texture_lod_bias import _EXTENSION_NAME

def glInitTextureLodBiasQCOM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION