# example.js

``` javascript
function getTemplate(templateName) {
	return require("./templates/"+templateName);
}
console.log(getTemplate("a"));
console.log(getTemplate("b"));
```

# templates/

* a.js
* b.js
* c.js

All templates are of this pattern:

``` javascript
module.exports = function() {
	return "This text was generated by template X";
}
```

# dist/output.js

``` javascript
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */
/*!**********************************!*\
  !*** ./templates/ sync ^\.\/.*$ ***!
  \**********************************/
/*! default exports */
/*! exports [not provided] [no usage info] */
/*! runtime requirements: module, __webpack_require__.o, __webpack_require__ */
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var map = {
	"./a": 2,
	"./a.js": 2,
	"./b": 3,
	"./b.js": 3,
	"./c": 4,
	"./c.js": 4
};


function webpackContext(req) {
	var id = webpackContextResolve(req);
	return __webpack_require__(id);
}
function webpackContextResolve(req) {
	if(!__webpack_require__.o(map, req)) {
		var e = new Error("Cannot find module '" + req + "'");
		e.code = 'MODULE_NOT_FOUND';
		throw e;
	}
	return map[req];
}
webpackContext.keys = function webpackContextKeys() {
	return Object.keys(map);
};
webpackContext.resolve = webpackContextResolve;
module.exports = webpackContext;
webpackContext.id = 1;

/***/ }),
/* 2 */
/*!************************!*\
  !*** ./templates/a.js ***!
  \************************/
/*! unknown exports (runtime-defined) */
/*! runtime requirements: module */
/*! CommonJS bailout: module.exports is used directly at 1:0-14 */
/***/ ((module) => {

module.exports = function() {
	return "This text was generated by template A";
}

/***/ }),
/* 3 */
/*!************************!*\
  !*** ./templates/b.js ***!
  \************************/
/*! unknown exports (runtime-defined) */
/*! runtime requirements: module */
/*! CommonJS bailout: module.exports is used directly at 1:0-14 */
/***/ ((module) => {

module.exports = function() {
	return "This text was generated by template B";
}

/***/ }),
/* 4 */
/*!************************!*\
  !*** ./templates/c.js ***!
  \************************/
/*! unknown exports (runtime-defined) */
/*! runtime requirements: module */
/*! CommonJS bailout: module.exports is used directly at 1:0-14 */
/***/ ((module) => {

module.exports = function() {
	return "This text was generated by template C";
}

/***/ })
/******/ 	]);
```

<details><summary><code>/* webpack runtime code */</code></summary>

``` js
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
```

</details>

``` js
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/*!********************!*\
  !*** ./example.js ***!
  \********************/
/*! unknown exports (runtime-defined) */
/*! runtime requirements: __webpack_require__ */
function getTemplate(templateName) {
	return __webpack_require__(1)("./"+templateName);
}
console.log(getTemplate("a"));
console.log(getTemplate("b"));
})();

/******/ })()
;
```

# Info

## Unoptimized

```
asset output.js 3.8 KiB [emitted] (name: main)
chunk (runtime: main) output.js (main) 603 bytes (javascript) 88 bytes (runtime) [entry] [rendered]
  > ./example.js main
  dependent modules 457 bytes [dependent] 4 modules
  runtime modules 88 bytes 1 module
  ./example.js 146 bytes [built] [code generated]
    [used exports unknown]
    entry ./example.js main
webpack 5.51.1 compiled successfully
```

## Production mode

```
asset output.js 833 bytes [emitted] [minimized] (name: main)
chunk (runtime: main) output.js (main) 603 bytes (javascript) 88 bytes (runtime) [entry] [rendered]
  > ./example.js main
  dependent modules 457 bytes [dependent] 4 modules
  runtime modules 88 bytes 1 module
  ./example.js 146 bytes [built] [code generated]
    [no exports used]
    entry ./example.js main
webpack 5.51.1 compiled successfully
```

# Code Splitting

See [this example combined with code splitting](../code-splitted-require.context)
