include(utils/disable_warnings)
include(utils/find_include_dirs)

set(INTERNAL_ZLIB_DIR ${SOURCE_DIR}/thirdparty/zlib-1.3.1)

if(USE_INTERNAL_ZLIB)
    file(GLOB_RECURSE ZLIB_SOURCES ${INTERNAL_ZLIB_DIR}/*.c)
    disable_warnings(ZLIB_SOURCES)
    find_include_dirs(ZLIB_INCLUDE_DIRS ${ZLIB_SOURCES})
    set(ZLIB_DEFINITIONS NO_GZIP)
    list(APPEND SERVER_LIBRARY_SOURCES ${ZLIB_SOURCES})
    list(APPEND CLIENT_LIBRARY_SOURCES ${ZLIB_SOURCES})
else()
    find_package(ZLIB REQUIRED)
endif()

list(APPEND SERVER_LIBRARIES ${ZLIB_LIBRARIES})
list(APPEND SERVER_INCLUDE_DIRS ${ZLIB_INCLUDE_DIRS})
list(APPEND SERVER_DEFINITIONS ${ZLIB_DEFINITIONS})
list(APPEND CLIENT_LIBRARIES ${ZLIB_LIBRARIES})
list(APPEND CLIENT_INCLUDE_DIRS ${ZLIB_INCLUDE_DIRS})
list(APPEND CLIENT_DEFINITIONS ${ZLIB_DEFINITIONS})
